<?php

declare(strict_types=1);

/**
 * (c) AI Fellows by webfellows UG (support@aifellows.eu)
 */

 namespace AI\Fellows\AssistantAddition\Subscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Shopware\Core\System\SystemConfig\SystemConfigService;
use Shopware\Storefront\Event\StorefrontRenderEvent; 
use Shopware\Core\PlatformRequest;

class PageOnLoad implements EventSubscriberInterface
{
    /**
     * @var SystemConfigService
     */
    private $systemConfigService; 

    public function __construct(
        SystemConfigService $systemConfigService
    ) {
        $this->systemConfigService = $systemConfigService;
    }

    public static function getSubscribedEvents(): array
    {
        return [
            StorefrontRenderEvent::class => 'onStorefrontRender'
        ];
    } 

    public function onStorefrontRender(StorefrontRenderEvent $event)
    {
        $salesChannelId = $event->getRequest()->get(PlatformRequest::ATTRIBUTE_SALES_CHANNEL_ID);
        $aifellowsAssistantScript = $this->systemConfigService->get('AIFellowsAssistantAddition.config',$salesChannelId);
        $event->setParameter('aifellowsAssistantScript', $aifellowsAssistantScript);
    }
}
