<?php
/**
 * Plugin Name: AI Fellows Integrated Chatbot
 * Description: Das offizielle WordPress-Plugin von AI Fellows ermöglicht das Hinzufügen von Integrated Chatbots. Der JavaScript-Code wird in den Head-Bereich jeder Seite eingefügt.
 * Version: 1.0
 * Author: <a href="https://aifellows.eu" target="_blank">AI Fellows by webfellows UG, Würzburg</a>
 * License: GPL2
 */

if (!defined('ABSPATH')) {
    exit; // Sicherstellen, dass das Skript nicht direkt aufgerufen wird.
}

// Funktion um das Plugin zu initialisieren
function aifellows_chatbot_menu() {
    add_menu_page('Chatbot Einstellungen', 'AI Fellows Chatbot', 'manage_options', 'aifellows-chatbot', 'aifellows_chatbot_settings_page');
}
add_action('admin_menu', 'aifellows_chatbot_menu');

// Funktion um die Plugin-Einstellungsseite anzuzeigen
function aifellows_chatbot_settings_page() {
    // Überprüfen ob der Benutzer die notwendigen Berechtigungen hat
    if (!current_user_can('manage_options')) {
        return;
    }

    // Speichern des Scripts bei Formularübermittlung
    if (isset($_POST['chatbot_script'])) {
        update_option('aifellows_chatbot_script', wp_unslash($_POST['chatbot_script']));
        echo '<div class="updated"><p>Einstellungen wurden erfolgreich gespeichert!</p></div>';
    }

    // Das aktuelle Script, falls vorhanden
    $script = get_option('aifellows_chatbot_script', '');

    ?>
    <div class="wrap-aifellows">
        <img src="https://aifellows.eu/new/img/ai_fellows_logo_color.png" alt="AI Fellows Logo" style="margin-top: 50px; margin-bottom: 20px;">
        <h1>AI Fellows Integrated Chatbot Einstellungen</h1>
        <div style="margin-top: 20px; margin-bottom: 20px;">Füge hier den Quellcode aus der AI Fellows Konfiguration für den Integrated Chatbot ein:</div>
        <form method="post">
            <textarea name="chatbot_script" rows="10" cols="50" style="width:100%;"><?php echo esc_textarea($script); ?></textarea>
            <p><input type="submit" value="Speichern" class="button button-primary" /></p>
        </form>
    </div>
    <?php
}

// Funktion um das Script dem Head hinzuzufügen
function aifellows_chatbot_head_script() {
    $script = get_option('aifellows_chatbot_script');
    if (!empty($script)) {
        echo $script;
    }
}
add_action('wp_head', 'aifellows_chatbot_head_script');


